<?php 

namespace App\Http\Resources\Transaction;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;

class EntryItemResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'account' => new \App\Http\Resources\Account\AccountResource($this->account),
            'cr_total' => $this->cr_total,
            'dr_total' => $this->dr_total,
            'reconciliation_date' => $this->reconciliation_date
        ];

        $array = $this->base($array);
        
        return $array;
    }
}