<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBondInvoicesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('invoice_date');
            $table->date('invoice_final_date')->nullable(true);
            $table->unsignedBigInteger('account_id');
            $table->string('invoice_number')->unique();
            $table->text('narration')->nullable(true);
            $table->enum('invoice_type', ['CONSUMABLE','POWDER', 'PENDING','PRODUCT']);

            $table->string('ref_number')->nullable(true);
            $table->decimal('taxable_amount', 25, 2)->default(0)->nullable(true);

            $table->decimal('cgst', 25, 2)->default(0)->nullable(true);
            $table->decimal('sgst', 25, 2)->default(0)->nullable(true);
            $table->decimal('igst', 25, 2)->default(0)->nullable(true);
            $table->decimal('net_gst', 25, 2)->default(0)->nullable(true);
            $table->decimal('packing_charge', 25, 2)->default(0)->nullable(true);

            $table->decimal('total_discount', 25, 2)->default(0)->nullable(true);
            
            $table->decimal('transport', 25, 2)->default(0)->nullable(true);
            $table->decimal('billedAmount', 25, 2)->default(0)->nullable(true);
            $table->decimal('totalAmount', 25, 2)->default(0)->nullable(true);
            $table->timestamps();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');   

            $table->foreign('account_id')->references('id')->on('accounts');
        });

        Schema::create('bond_invoice_detail', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('invoice_id');
            $table->unsignedBigInteger('packing_id')->unique();
            $table->timestamps();
            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
            $table->foreign('packing_id')->references('packing_id')->on('production_packagings');

            $table->decimal('unit_price',25,2)->nullable(true);
            $table->decimal('amount',25,2)->nullable(true);


            $table->decimal('cgst', 25, 2)->default(0)->nullable(true);
            $table->decimal('sgst', 25, 2)->default(0)->nullable(true);
            $table->decimal('igst', 25, 2)->default(0)->nullable(true);

            $table->decimal('cgst_value', 25, 2)->default(0)->nullable(true);
            $table->decimal('sgst_value', 25, 2)->default(0)->nullable(true);
            $table->decimal('igst_value', 25, 2)->default(0)->nullable(true);
            $table->decimal('net_gst', 25, 2)->default(0)->nullable(true);

            $table->decimal('discount', 25, 2)->default(0)->nullable(true);
            $table->decimal('discount_val', 25, 2)->default(0)->nullable(true);

            $table->decimal('net_amount', 25,2 )->default(0)->nullable(true);

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');   

        });

        // Schema::create('bond_performance', function (Blueprint $table) {
        //     $table->bigIncrements('id');
        //     $table->unsignedBigInteger('invoice_id');

        //     $table->decimal('trolley',25,2);
        //     $table->decimal('speed',25,2);
        //     $table->decimal('machine_stroke',25,2);
                       
        //     $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
        //     $table->timestamps();
        //     $table->unsignedBigInteger('created_by')->nullable(false);
        //     $table->unsignedBigInteger('updated_by')->nullable();
        //     //$table->unsignedBigInteger('deleted_by')->nullable();
        //     $table->foreign('created_by')->references('id')->on('users');
        //     $table->foreign('updated_by')->references('id')->on('users');   
        // });

        Schema::create('invoice_consumable_detail', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('invoice_id');
            $table->unsignedBigInteger('consumable_id');
            $table->decimal('qty',25,2);
            $table->decimal('unit_price',25,2);
            $table->decimal('amount',25,2);

            $table->decimal('cgst', 25, 2)->default(0)->nullable(true);
            $table->decimal('sgst', 25, 2)->default(0)->nullable(true);
            $table->decimal('igst', 25, 2)->default(0)->nullable(true);

            $table->decimal('cgst_value', 25, 2)->default(0)->nullable(true);
            $table->decimal('sgst_value', 25, 2)->default(0)->nullable(true);
            $table->decimal('igst_value', 25, 2)->default(0)->nullable(true);
            $table->decimal('net_gst', 25, 2)->default(0)->nullable(true);

            $table->decimal('discount', 25, 2)->default(0)->nullable(true);
            $table->decimal('discount_val', 25, 2)->default(0)->nullable(true);

            $table->decimal('net_amount', 25,2 )->default(0)->nullable(true);

            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
            $table->timestamps();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');   
        });

        Schema::table('entries', function (Blueprint $table) {
            $table->foreign('invoice_ref_id')->references('id')->on('invoices')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('invoices');
        Schema::drop('bond_invoice_detail');
        Schema::drop('bond_price_detail');
        Schema::drop('invoice_consumable_detail');
    }
}
