<?php

namespace App\Http\Controllers;

use App\DataTables\GreenPieceSettingsDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateGreenPieceSettingsRequest;
use App\Http\Requests\UpdateGreenPieceSettingsRequest;
use App\Repositories\GreenPieceSettingsRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class GreenPieceSettingsController extends AppBaseController
{
    /** @var  GreenPieceSettingsRepository */
    private $greenPieceSettingsRepository;

    public function __construct(GreenPieceSettingsRepository $greenPieceSettingsRepo)
    {
        $this->greenPieceSettingsRepository = $greenPieceSettingsRepo;
    }

    /**
     * Display a listing of the GreenPieceSettings.
     *
     * @param GreenPieceSettingsDataTable $greenPieceSettingsDataTable
     * @return Response
     */
    public function index(GreenPieceSettingsDataTable $greenPieceSettingsDataTable)
    {
        return $greenPieceSettingsDataTable->render('green_piece_settings.index');
    }

    /**
     * Show the form for creating a new GreenPieceSettings.
     *
     * @return Response
     */
    public function create()
    {
        return view('green_piece_settings.create');
    }

    /**
     * Store a newly created GreenPieceSettings in storage.
     *
     * @param CreateGreenPieceSettingsRequest $request
     *
     * @return Response
     */
    public function store(CreateGreenPieceSettingsRequest $request)
    {
        $input = $request->all();

        $greenPieceSettings = $this->greenPieceSettingsRepository->create($input);

        Flash::success('Green Piece Settings saved successfully.');

        return redirect(route('greenPieceSettings.index'));
    }

    /**
     * Display the specified GreenPieceSettings.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $greenPieceSettings = $this->greenPieceSettingsRepository->find($id);

        if (empty($greenPieceSettings)) {
            Flash::error('Green Piece Settings not found');

            return redirect(route('greenPieceSettings.index'));
        }

        return view('green_piece_settings.show')->with('greenPieceSettings', $greenPieceSettings);
    }

    /**
     * Show the form for editing the specified GreenPieceSettings.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $greenPieceSettings = $this->greenPieceSettingsRepository->find($id);

        if (empty($greenPieceSettings)) {
            Flash::error('Green Piece Settings not found');

            return redirect(route('greenPieceSettings.index'));
        }

        return view('green_piece_settings.edit')->with('greenPieceSettings', $greenPieceSettings);
    }

    /**
     * Update the specified GreenPieceSettings in storage.
     *
     * @param  int              $id
     * @param UpdateGreenPieceSettingsRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateGreenPieceSettingsRequest $request)
    {
        $greenPieceSettings = $this->greenPieceSettingsRepository->find($id);

        if (empty($greenPieceSettings)) {
            Flash::error('Green Piece Settings not found');

            return redirect(route('greenPieceSettings.index'));
        }

        $greenPieceSettings = $this->greenPieceSettingsRepository->update($request->all(), $id);

        Flash::success('Green Piece Settings updated successfully.');

        return redirect(route('greenPieceSettings.index'));
    }

    /**
     * Remove the specified GreenPieceSettings from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $greenPieceSettings = $this->greenPieceSettingsRepository->find($id);

        if (empty($greenPieceSettings)) {
            Flash::error('Green Piece Settings not found');

            return redirect(route('greenPieceSettings.index'));
        }

        $this->greenPieceSettingsRepository->delete($id);

        Flash::success('Green Piece Settings deleted successfully.');

        return redirect(route('greenPieceSettings.index'));
    }
}
