<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class BondDesign
 * @package App\Models
 * @version November 9, 2019, 6:22 pm UTC
 *
 */
class BondDesign extends CRUDAwareModel
{
    //use SoftDeletes;

    public $table = 'bond_designs';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'size_specification',
        'size_print',
        'weight1_lower',
        'weight1_upper',
        'weight2_lower',
        'weight2_upper',
        'weight1_name',
        'weight2_name',
        'weight1_nos',
        'weight2_nos',
        'weight1_average',
        'weight2_average',
        'num_of_patti',
        'consumable_setting_1',
        'consumable_setting_2',
        'width',
        'piece_net_weight',
        'shape',
        'taper'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        "weight1_lower" => "float",
        "weight1_upper" => "float",
        "weight2_lower" => "float",
        "weight2_upper" => "float",
        "weight1_average" => "float",
        "weight2_average" => "float",
        "weight1_nos" => "integer",
        "weight2_nos" => "integer",
        "taper" => "float",
        "width" => "float"
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name.*' => 'required|unique:bond_designs',
        'weight1_name' => 'required',
        'weight1_lower' => 'required|numeric',
        'weight1_upper' => 'required|numeric',
        'weight1_nos' => 'required|integer',
        'weight2_lower' => 'nullable|numeric',
        'weight2_upper' => 'required_with:weight2_lower|nullable|numeric',
        'weight2_nos' => 'required_with:weight2_lower|nullable|integer',
        'width' => 'required|numeric',
        'taper' => 'nullable|numeric'

    ];

    public function consumableSetting1(){
        return $this->belongsTo('App\Models\ConsumableSettings','consumable_setting_1');
    } 
    public function consumableSetting2(){
        return $this->belongsTo('App\Models\ConsumableSettings','consumable_setting_2');
    } 


    
}
