<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBondDesign extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_designs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('size_specification');
            $table->string('size_print')->nullable(true);
           
           // $table->enum('design_type', ['SANDWITCH', 'WIRESAW_PEARL'] );
            $table->decimal('weight1_lower', 25, 2)->nullable(true);
            $table->decimal('weight1_upper', 25, 2)->nullable(true);
            $table->integer('weight1_nos')->nullable(true);

            $table->decimal('weight2_lower', 25, 2)->nullable(true);
            $table->decimal('weight2_upper', 25, 2)->nullable(true);
            $table->integer('weight2_nos')->nullable(true);


            $table->decimal('weight1_average', 25, 2)->nullable(true);
            $table->decimal('weight2_average', 25, 2)->nullable(true);

            $table->string('weight1_name')->nullable(true);
            $table->string('weight2_name')->nullable(true);
            
            $table->unsignedBigInteger('consumable_setting_1');
            $table->unsignedBigInteger('consumable_setting_2')->nullable(true);

            $table->decimal('piece_net_weight', 25, 2);
            $table->enum('shape',['BOX-SHAPE', 'M-SHAPE','B-SHAPE', 'V-SHAPE']);
            $table->decimal('taper',25,2)->default(0);
            $table->decimal('width', 25, 2)->nullable(true);
            $table->timestamps();
           // $table->softDeletes();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            //$table->foreign('deleted_by')->references('id')->on('users'); 

            $table->foreign('consumable_setting_1')->references('id')->on('consumable_settings');  
            $table->foreign('consumable_setting_2')->references('id')->on('consumable_settings');  

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bond_designs');
    }
}
