<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumableConsumpationsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consumable_consumpations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->dateTime('change_date');
            $table->string('narration')->nullable(true);
            $table->enum('change_reason', CreateUsersTable::f(config('app_data.consumable_reason_enum')));
            $table->timestamps();
        });


        Schema::create('consumable_consumpation_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('consumpation_id');
            $table->unsignedBigInteger('consumable_id');
            $table->decimal('qty', 25, 2);
            $table->decimal('consumed_percentage', 10, 2)->nullable(true);
            $table->timestamps();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();

            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        

            $table->foreign('consumpation_id')->references('id')->on('consumable_consumpations')->onDelete('cascade');
            $table->foreign('consumable_id')->references('id')->on('consumable_items');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('consumable_consumpations');
    }
}
