<?php

namespace App\Http\Controllers;

use App\DataTables\ConsumableConsumpationDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateConsumableConsumpationRequest;
use App\Http\Requests\UpdateConsumableConsumpationRequest;
use App\Repositories\ConsumableConsumpationRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;
use App\Http\Requests\AttachConsumableConsumpationRequest;
use Illuminate\Http\Request;

class ConsumableConsumpationController extends AppBaseController
{
    /** @var  ConsumableConsumpationRepository */
    private $consumableConsumpationRepository;

    public function __construct(ConsumableConsumpationRepository $consumableConsumpationRepo)
    {
        $this->consumableConsumpationRepository = $consumableConsumpationRepo;
    }

    /**
     * Display a listing of the ConsumableConsumpation.
     *
     * @param ConsumableConsumpationDataTable $consumableConsumpationDataTable
     * @return Response
     */
    public function index(ConsumableConsumpationDataTable $consumableConsumpationDataTable)
    {
        return $consumableConsumpationDataTable->render('consumable_consumpations.index');
    }

    /**
     * Show the form for creating a new ConsumableConsumpation.
     *
     * @return Response
     */
    public function create()
    {
        return view('consumable_consumpations.create');
    }

    public function attachConsumpation($id)
    {
        $data = \App\Models\ConsumableCategory::pluck('name')->toArray();
        $settings = \App\Models\ConsumableConsumpation::find($id);
        //dd($data);
        return view('consumable_consumpations.attach')->with('settings', $settings)->with('categories', $data);
    }

    public function deleteConsumpation($id, Request $request)
    {
        $input = $request->all();
        $item = \App\Models\ConsumableConsumpationDetail::find((int)$input['id']);
        if(!empty($item)){
            $item->forceDelete();
        }
        
        return $this->getConsumpation($id);
    }

    public function saveConsumpation($id, AttachConsumableConsumpationRequest $request){
        $input = $request->all();
        //dd($input);
        $item = \App\Models\ConsumableItem::where('name->en', '=', $input['item'])->first();
        $obj = null;
        if(!empty($item)){
            $obj=\App\Models\ConsumableConsumpationDetail::create([
                'consumpation_id' => $id, 
                'consumable_id' => $item->id,
                'qty' => $input['qty'],
                'consumed_percentage' => $input['consumed_percentage'],
                'created_at' => \Carbon\Carbon::now(),
                'created_by' => \Auth::user()->id
            ]);
        }
        \App\Http\Resources\ConsumableConsumpationDetailResource::withoutWrapping();
        return new \App\Http\Resources\ConsumableConsumpationDetailResource($obj);
    }

    public function updateConsumpation($id, AttachConsumableConsumpationRequest $request){
        $input = $request->all();
        //dd($input);
        $item = \App\Models\ConsumableItem::where('name->en', $input['item'])->first();
        $obj = null;
        if(!empty($item)){
            $detail = \App\Models\ConsumableConsumpationDetail::find((int)$input['id']);
            $detail->update([
                'consumpation_id' => $id, 
                'consumable_id' => $item->id,
                'qty' => $input['qty'],
                'consumed_percentage' => $input['consumed_percentage'],
                'updated_at' => \Carbon\Carbon::now(),
                'updated_by' => \Auth::user()->id
            ]);
        }
        \App\Http\Resources\ConsumableConsumpationDetailResource::withoutWrapping();
        return new \App\Http\Resources\ConsumableConsumpationDetailResource($detail);
        
    }



    public function getConsumpation($id){
        $settings = \App\Models\ConsumableConsumpationDetail::where('consumpation_id','=', $id)->get();
        //\App\Http\Resources\ConsumableSettingsDetailResource::withoutWrapping();
        return \App\Http\Resources\ConsumableConsumpationDetailResource::collection($settings);
        
    }


    /**
     * Store a newly created ConsumableConsumpation in storage.
     *
     * @param CreateConsumableConsumpationRequest $request
     *
     * @return Response
     */
    public function store(CreateConsumableConsumpationRequest $request)
    {
        $input = $request->all();

        $consumableConsumpation = $this->consumableConsumpationRepository->create($input);

        Flash::success('Consumable Consumpation saved successfully.');

        return redirect(route('consumableConsumpations.index'));
    }

    /**
     * Display the specified ConsumableConsumpation.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $consumableConsumpation = $this->consumableConsumpationRepository->find($id);

        if (empty($consumableConsumpation)) {
            Flash::error('Consumable Consumpation not found');

            return redirect(route('consumableConsumpations.index'));
        }

        return view('consumable_consumpations.show')->with('consumableConsumpation', $consumableConsumpation);
    }

    /**
     * Show the form for editing the specified ConsumableConsumpation.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $consumableConsumpation = $this->consumableConsumpationRepository->find($id);

        if (empty($consumableConsumpation)) {
            Flash::error('Consumable Consumpation not found');

            return redirect(route('consumableConsumpations.index'));
        }

        return view('consumable_consumpations.edit')->with('consumableConsumpation', $consumableConsumpation);
    }

    /**
     * Update the specified ConsumableConsumpation in storage.
     *
     * @param  int              $id
     * @param UpdateConsumableConsumpationRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateConsumableConsumpationRequest $request)
    {
        $consumableConsumpation = $this->consumableConsumpationRepository->find($id);

        if (empty($consumableConsumpation)) {
            Flash::error('Consumable Consumpation not found');

            return redirect(route('consumableConsumpations.index'));
        }

        $consumableConsumpation = $this->consumableConsumpationRepository->update($request->all(), $id);

        Flash::success('Consumable Consumpation updated successfully.');

        return redirect(route('consumableConsumpations.index'));
    }

    /**
     * Remove the specified ConsumableConsumpation from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $consumableConsumpation = $this->consumableConsumpationRepository->find($id);

        if (empty($consumableConsumpation)) {
            Flash::error('Consumable Consumpation not found');

            return redirect(route('consumableConsumpations.index'));
        }

        $this->consumableConsumpationRepository->delete($id);

        Flash::success('Consumable Consumpation deleted successfully.');

        return redirect(route('consumableConsumpations.index'));
    }
}
