/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRewriteEngine;
import antlr.TokenWithIndex;
import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.LookaheadSet;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAConversionThread;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Barrier;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.ANTLRLexer;
import org.antlr.tool.ANTLRParser;
import org.antlr.tool.ANTLRTreePrinter;
import org.antlr.tool.AssignTokenTypesWalker;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.DefineGrammarItemsWalker;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.NFAFactory;
import org.antlr.tool.NameSpaceChecker;
import org.antlr.tool.Rule;
import org.antlr.tool.TreeToNFAConverter;

public class Grammar {
    public static final String SYNPRED_RULE_PREFIX = "synpred";
    public static final String GRAMMAR_FILE_EXTENSION = ".g";
    public static final int INITIAL_DECISION_LIST_SIZE = 300;
    public static final int INVALID_RULE_INDEX = -1;
    public static final int RULE_LABEL = 1;
    public static final int TOKEN_LABEL = 2;
    public static final int RULE_LIST_LABEL = 3;
    public static final int TOKEN_LIST_LABEL = 4;
    public static String[] LabelTypeToString = new String[]{"<invalid>", "rule", "token", "rule-list", "token-list"};
    public static final String ARTIFICIAL_TOKENS_RULENAME = "Tokens";
    public static final String FRAGMENT_RULE_MODIFIER = "fragment";
    public static final String SYNPREDGATE_ACTION_NAME = "synpredgate";
    public static int[] ANTLRLiteralEscapedCharValue = new int[255];
    public static String[] ANTLRLiteralCharValueEscape = new String[255];
    public static final int LEXER = 1;
    public static final int PARSER = 2;
    public static final int TREE_PARSER = 3;
    public static final int COMBINED = 4;
    public static final String[] grammarTypeToString;
    public static final String[] grammarTypeToFileNameSuffix;
    protected TokenStreamRewriteEngine tokenBuffer;
    public static final String IGNORE_STRING_IN_GRAMMAR_FILE_NAME = "__";
    public String name;
    public int type;
    protected Map options;
    public static final Set legalOptions;
    public static final Set doNotCopyOptionsToLexer;
    public static final Map defaultOptions;
    protected int global_k = -1;
    protected Map actions = new HashMap();
    protected NFA nfa;
    protected int maxTokenType = 3;
    protected IntSet charVocabulary = null;
    protected Map tokenIDToTypeMap = new HashMap();
    protected Map stringLiteralToTypeMap = new HashMap();
    protected Vector typeToTokenList = new Vector();
    protected Grammar importTokenVocabularyFromGrammar;
    Map lineColumnToLookaheadDFAMap = new HashMap();
    protected Tool tool;
    protected Set ruleRefs = new HashSet();
    protected Set tokenIDRefs = new HashSet();
    protected Set lexerRules = new HashSet();
    protected int decisionNumber = 0;
    protected int ruleIndex = 1;
    protected Set leftRecursiveRules;
    protected boolean externalAnalysisAbort;
    protected LinkedHashMap nameToSynpredASTMap;
    protected LinkedHashMap nameToRuleMap = new LinkedHashMap();
    protected Map scopes = new HashMap();
    protected Vector ruleIndexToRuleList = new Vector();
    protected GrammarAST grammarTree = null;
    protected Vector indexToDecision = new Vector(300);
    protected CodeGenerator generator;
    NameSpaceChecker nameSpaceChecker = new NameSpaceChecker(this);
    protected Set lookBusy = new HashSet();
    protected Set visitedDuringRecursionCheck = null;
    protected boolean watchNFAConversion = false;
    protected StringTemplate lexerGrammarST = new StringTemplate("lexer grammar <name>;\n<if(options)>options {\n  <options:{<it.name>=<it.value>;<\\n>}>\n}<\\n>\n<endif>\n<actionNames,actions:{n,a|@<n> {<a>}\n}>\n<literals:{<it.ruleName> : <it.literal> ;\n}>\n<rules>", AngleBracketTemplateLexer.class);
    protected String fileName;
    public long DFACreationWallClockTimeInMS;
    public int numberOfSemanticPredicates = 0;
    public int numberOfManualLookaheadOptions = 0;
    public Set setOfNondeterministicDecisionNumbers = new HashSet();
    public Set setOfNondeterministicDecisionNumbersResolvedWithPredicates = new HashSet();
    public Set setOfDFAWhoseConversionTerminatedEarly = new HashSet();
    public Set blocksWithSynPreds = new HashSet();
    public Set decisionsWhoseDFAsUsesSynPreds = new HashSet();
    public Set synPredNamesUsedInDFA = new HashSet();
    public Set blocksWithSemPreds = new HashSet();
    public Set decisionsWhoseDFAsUsesSemPreds = new HashSet();
    protected boolean allDecisionDFACreated = false;
    protected boolean builtFromString = false;

    public Grammar() {
        this.initTokenSymbolTables();
        this.builtFromString = true;
    }

    public Grammar(String string) throws RecognitionException, TokenStreamException {
        this.builtFromString = true;
        this.initTokenSymbolTables();
        this.setFileName("<string>");
        this.setGrammarContent(new StringReader(string));
    }

    public Grammar(String string, String string2) throws RecognitionException, TokenStreamException {
        this(null, string, new StringReader(string2));
    }

    public Grammar(Tool tool, String string, Reader reader) throws RecognitionException, TokenStreamException {
        this.initTokenSymbolTables();
        this.setTool(tool);
        this.setFileName(string);
        this.setGrammarContent(reader);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.fileName.replace('\\', '/');
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(n + 1, this.fileName.length());
        if (!this.builtFromString) {
            int n2 = string3.lastIndexOf(46);
            String string4 = null;
            if (n2 < 0) {
                ErrorManager.error(9, this.fileName);
                string4 = string3 + GRAMMAR_FILE_EXTENSION;
            } else {
                string4 = string3.substring(0, n2);
            }
            if (!string.equals(string4)) {
                ErrorManager.error(8, (Object)string, this.fileName);
            }
        }
        this.name = string;
    }

    public String getFileDirectory() {
        File file = new File(this.fileName);
        String string = file.getParent();
        return string;
    }

    public void setGrammarContent(String string) throws RecognitionException, TokenStreamException {
        this.setGrammarContent(new StringReader(string));
    }

    public void setGrammarContent(Reader reader) throws RecognitionException, TokenStreamException {
        Object object;
        ErrorManager.resetErrorState();
        ANTLRLexer aNTLRLexer = new ANTLRLexer(reader);
        aNTLRLexer.setFilename(this.getFileName());
        aNTLRLexer.setTokenObjectClass("antlr.TokenWithIndex");
        this.tokenBuffer = new TokenStreamRewriteEngine((TokenStream)aNTLRLexer);
        this.tokenBuffer.discard(83);
        this.tokenBuffer.discard(86);
        this.tokenBuffer.discard(84);
        this.tokenBuffer.discard(85);
        ANTLRParser aNTLRParser = new ANTLRParser((TokenStream)this.tokenBuffer);
        aNTLRParser.setFilename(this.getFileName());
        aNTLRParser.setASTNodeClass("org.antlr.tool.GrammarAST");
        aNTLRParser.grammar(this);
        this.grammarTree = (GrammarAST)aNTLRParser.getAST();
        this.setFileName(aNTLRLexer.getFilename());
        if (this.grammarTree.findFirstType(8) == null) {
            ErrorManager.error(150, this.getFileName());
            return;
        }
        List list = this.getArtificialRulesForSyntacticPredicates(aNTLRParser, this.nameToSynpredASTMap);
        for (int i = 0; i < list.size(); ++i) {
            object = (GrammarAST)((Object)list.get(i));
            this.grammarTree.addChild((AST)object);
        }
        if (Tool.internalOption_PrintGrammarTree) {
            System.out.println(this.grammarTree.toStringList());
        }
        AssignTokenTypesWalker assignTokenTypesWalker = new AssignTokenTypesWalker();
        assignTokenTypesWalker.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            assignTokenTypesWalker.grammar((AST)this.grammarTree, this);
        }
        catch (RecognitionException recognitionException) {
            ErrorManager.error(15, recognitionException);
        }
        object = new DefineGrammarItemsWalker();
        object.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            ((DefineGrammarItemsWalker)object).grammar((AST)this.grammarTree, this);
        }
        catch (RecognitionException recognitionException) {
            ErrorManager.error(15, recognitionException);
        }
        this.nameSpaceChecker.checkConflicts();
    }

    public String getLexerGrammar() {
        if (this.lexerGrammarST.getAttribute("literals") == null && this.lexerGrammarST.getAttribute("rules") == null) {
            return null;
        }
        this.lexerGrammarST.setAttribute("name", (Object)this.name);
        if (this.actions.get("lexer") != null) {
            this.lexerGrammarST.setAttribute("actionNames", ((Map)this.actions.get("lexer")).keySet());
            this.lexerGrammarST.setAttribute("actions", ((Map)this.actions.get("lexer")).values());
        }
        if (this.options != null) {
            Iterator iterator = this.options.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (doNotCopyOptionsToLexer.contains(string)) continue;
                Object v = this.options.get(string);
                this.lexerGrammarST.setAttribute("options.{name,value}", (Object)string, v);
            }
        }
        return this.lexerGrammarST.toString();
    }

    public GrammarAST addArtificialMatchTokensRule(GrammarAST grammarAST, List list, boolean bl) {
        String string;
        StringTemplate stringTemplate = null;
        stringTemplate = bl ? new StringTemplate("Tokens options {k=1;} : <rules:{r| (<r>)=><r>}; separator=\"|\">;", AngleBracketTemplateLexer.class) : new StringTemplate("Tokens : <rules; separator=\"|\">;", AngleBracketTemplateLexer.class);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            stringTemplate.setAttribute("rules", (Object)string);
            ++n;
        }
        ANTLRLexer aNTLRLexer = new ANTLRLexer(new StringReader(stringTemplate.toString()));
        aNTLRLexer.setTokenObjectClass("antlr.TokenWithIndex");
        string = new TokenStreamRewriteEngine((TokenStream)aNTLRLexer);
        string.discard(83);
        string.discard(86);
        string.discard(84);
        string.discard(85);
        ANTLRParser aNTLRParser = new ANTLRParser((TokenStream)string);
        aNTLRParser.grammar = this;
        aNTLRParser.gtype = 27;
        aNTLRParser.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            aNTLRParser.rule();
            if (Tool.internalOption_PrintGrammarTree) {
                System.out.println("Tokens rule: " + aNTLRParser.getAST().toStringTree());
            }
            GrammarAST grammarAST2 = grammarAST;
            while (grammarAST2.getType() != 27) {
                grammarAST2 = (GrammarAST)grammarAST2.getNextSibling();
            }
            grammarAST2.addChild(aNTLRParser.getAST());
        }
        catch (Exception exception) {
            ErrorManager.error(12, exception);
        }
        return (GrammarAST)aNTLRParser.getAST();
    }

    protected List getArtificialRulesForSyntacticPredicates(ANTLRParser aNTLRParser, LinkedHashMap linkedHashMap) {
        ArrayList<GrammarAST> arrayList = new ArrayList<GrammarAST>();
        if (linkedHashMap == null) {
            return arrayList;
        }
        Set set = linkedHashMap.keySet();
        boolean bl = this.grammarTree.getType() == 27;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            GrammarAST grammarAST = (GrammarAST)((Object)linkedHashMap.get(string));
            GrammarAST grammarAST2 = aNTLRParser.createSimpleRuleAST(string, grammarAST, bl);
            arrayList.add(grammarAST2);
        }
        return arrayList;
    }

    protected void initTokenSymbolTables() {
        this.typeToTokenList.setSize(9);
        this.typeToTokenList.set(0, "<INVALID>");
        this.typeToTokenList.set(4, "<EOT>");
        this.typeToTokenList.set(2, "<SEMPRED>");
        this.typeToTokenList.set(3, "<SET>");
        this.typeToTokenList.set(1, "<EPSILON>");
        this.typeToTokenList.set(5, "EOF");
        this.typeToTokenList.set(6, "<EOR>");
        this.typeToTokenList.set(7, "Token.DOWN");
        this.typeToTokenList.set(8, "Token.UP");
        this.tokenIDToTypeMap.put("<INVALID>", Utils.integer(-6));
        this.tokenIDToTypeMap.put("<EOT>", Utils.integer(-2));
        this.tokenIDToTypeMap.put("<SEMPRED>", Utils.integer(-4));
        this.tokenIDToTypeMap.put("<SET>", Utils.integer(-3));
        this.tokenIDToTypeMap.put("<EPSILON>", Utils.integer(-5));
        this.tokenIDToTypeMap.put("EOF", Utils.integer(-1));
        this.tokenIDToTypeMap.put("<EOR>", Utils.integer(1));
        this.tokenIDToTypeMap.put("DOWN", Utils.integer(2));
        this.tokenIDToTypeMap.put("UP", Utils.integer(3));
    }

    public void createNFAs() {
        if (this.nfa != null) {
            return;
        }
        if (this.getRules().size() == 0) {
            return;
        }
        this.nfa = new NFA(this);
        NFAFactory nFAFactory = new NFAFactory(this.nfa);
        TreeToNFAConverter treeToNFAConverter = new TreeToNFAConverter(this, this.nfa, nFAFactory);
        try {
            treeToNFAConverter.grammar((AST)this.grammarTree);
        }
        catch (RecognitionException recognitionException) {
            ErrorManager.error(15, (Object)this.name, recognitionException);
        }
    }

    public void createLookaheadDFAs() {
        if (this.nfa == null) {
            this.createNFAs();
        }
        long l = System.currentTimeMillis();
        int n = this.getNumberOfDecisions();
        if (NFAToDFAConverter.SINGLE_THREADED_NFA_CONVERSION) {
            for (int i = 1; i <= n; ++i) {
                NFAState nFAState = this.getDecisionNFAStartState(i);
                if (this.externalAnalysisAbort || nFAState.getNumberOfTransitions() <= 1) continue;
                this.createLookaheadDFA(i);
            }
        } else {
            ErrorManager.info("two-threaded DFA conversion");
            Barrier barrier = new Barrier(3);
            int n2 = n / 2;
            NFAConversionThread nFAConversionThread = new NFAConversionThread(this, barrier, 1, n2);
            new Thread(nFAConversionThread).start();
            if (n2 == n / 2) {
                ++n2;
            }
            NFAConversionThread nFAConversionThread2 = new NFAConversionThread(this, barrier, n2, n);
            new Thread(nFAConversionThread2).start();
            try {
                barrier.waitForRelease();
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.internalError("what the hell? DFA interruptus", interruptedException);
            }
        }
        long l2 = System.currentTimeMillis();
        this.DFACreationWallClockTimeInMS = l2 - l;
        this.allDecisionDFACreated = true;
    }

    public void createLookaheadDFA(int n) {
        DFA dFA;
        Decision decision = this.getDecision(n);
        String string = decision.startState.getEnclosingRule();
        Rule rule = this.getRule(string);
        if (rule.isSynPred && !this.synPredNamesUsedInDFA.contains(string)) {
            return;
        }
        NFAState nFAState = this.getDecisionNFAStartState(n);
        long l = 0L;
        long l2 = 0L;
        if (this.watchNFAConversion) {
            System.out.println("--------------------\nbuilding lookahead DFA (d=" + nFAState.getDecisionNumber() + ") for " + nFAState.getDescription());
            l = System.currentTimeMillis();
        }
        if ((dFA = new DFA(n, nFAState)).analysisAborted() && dFA.getUserMaxLookahead() != 1 || dFA.probe.nonRegularDecision() && dFA.getAutoBacktrackMode()) {
            this.decisionsWhoseDFAsUsesSynPreds.remove(dFA);
            dFA = null;
            decision.blockAST.setOption(this, "k", Utils.integer(1));
            dFA = new DFA(n, nFAState);
            if (dFA.analysisAborted()) {
                ErrorManager.internalError("could not even do k=1 for decision " + n);
            }
        }
        this.setLookaheadDFA(n, dFA);
        GrammarAST grammarAST = this.nfa.grammar.getDecisionBlockAST(dFA.decisionNumber);
        int n2 = grammarAST.getLine();
        int n3 = grammarAST.getColumn();
        this.lineColumnToLookaheadDFAMap.put(n2 + ":" + n3, dFA);
        if (this.watchNFAConversion) {
            l2 = System.currentTimeMillis();
            System.out.println("cost: " + dFA.getNumberOfStates() + " states, " + (int)(l2 - l) + " ms");
        }
    }

    public void abortNFAToDFAConversion() {
        this.externalAnalysisAbort = true;
    }

    public int getNewTokenType() {
        ++this.maxTokenType;
        return this.maxTokenType;
    }

    public void defineToken(String string, int n) {
        String string2;
        if (this.tokenIDToTypeMap.get(string) != null) {
            return;
        }
        if (string.charAt(0) == '\'') {
            this.stringLiteralToTypeMap.put(string, Utils.integer(n));
        } else {
            this.tokenIDToTypeMap.put(string, Utils.integer(n));
        }
        int n2 = 6 + n - 1;
        this.maxTokenType = Math.max(this.maxTokenType, n);
        if (n2 >= this.typeToTokenList.size()) {
            this.typeToTokenList.setSize(n2 + 1);
        }
        if ((string2 = (String)this.typeToTokenList.get(n2)) == null || string2.charAt(0) == '\'') {
            this.typeToTokenList.set(n2, string);
        }
    }

    public void defineRule(Token token, String string, Map map, GrammarAST grammarAST, GrammarAST grammarAST2, int n) {
        String string2 = token.getText();
        if (this.getRule(string2) != null) {
            ErrorManager.grammarError(101, this, token, string2);
        }
        Rule rule = new Rule(this, string2, this.ruleIndex, n);
        rule.modifier = string;
        this.nameToRuleMap.put(string2, rule);
        this.setRuleAST(string2, grammarAST);
        rule.setOptions(map, token);
        rule.argActionAST = grammarAST2;
        this.ruleIndexToRuleList.setSize(this.ruleIndex + 1);
        this.ruleIndexToRuleList.set(this.ruleIndex, string2);
        ++this.ruleIndex;
        if (string2.startsWith(SYNPRED_RULE_PREFIX)) {
            rule.isSynPred = true;
        }
    }

    public String defineSyntacticPredicate(GrammarAST grammarAST, String string) {
        if (this.nameToSynpredASTMap == null) {
            this.nameToSynpredASTMap = new LinkedHashMap();
        }
        String string2 = null;
        string2 = SYNPRED_RULE_PREFIX + (this.nameToSynpredASTMap.size() + 1);
        this.nameToSynpredASTMap.put(string2, grammarAST);
        return string2;
    }

    public LinkedHashMap getSyntacticPredicates() {
        return this.nameToSynpredASTMap;
    }

    public GrammarAST getSyntacticPredicate(String string) {
        if (this.nameToSynpredASTMap == null) {
            return null;
        }
        return (GrammarAST)((Object)this.nameToSynpredASTMap.get(string));
    }

    public void synPredUsedInDFA(DFA dFA, SemanticContext semanticContext) {
        this.decisionsWhoseDFAsUsesSynPreds.add(dFA);
        semanticContext.trackUseOfSyntacticPredicates(this);
    }

    public void defineAction(GrammarAST grammarAST, String string, GrammarAST grammarAST2, GrammarAST grammarAST3) {
        GrammarAST grammarAST4;
        if (string == null) {
            string = this.getDefaultActionScope(this.type);
        }
        String string2 = grammarAST2.getText();
        HashMap<String, GrammarAST> hashMap = (HashMap<String, GrammarAST>)this.actions.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, GrammarAST>();
            this.actions.put(string, hashMap);
        }
        if ((grammarAST4 = (GrammarAST)((Object)hashMap.get(string2))) != null) {
            ErrorManager.grammarError(144, this, grammarAST2.getToken(), grammarAST2.getText());
        } else {
            hashMap.put(string2, grammarAST3);
        }
    }

    public Map getActions() {
        return this.actions;
    }

    public String getDefaultActionScope(int n) {
        switch (n) {
            case 1: {
                return "lexer";
            }
            case 2: 
            case 4: {
                return "parser";
            }
            case 3: {
                return "treeparser";
            }
        }
        return null;
    }

    public void defineLexerRuleFoundInParser(Token token, GrammarAST grammarAST) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// $ANTLR src \"");
        stringBuffer.append(this.getFileName());
        stringBuffer.append("\" ");
        stringBuffer.append(grammarAST.getLine());
        stringBuffer.append("\n");
        for (int i = grammarAST.ruleStartTokenIndex; i <= grammarAST.ruleStopTokenIndex && i < this.tokenBuffer.size(); ++i) {
            TokenWithIndex tokenWithIndex = this.tokenBuffer.getToken(i);
            if (tokenWithIndex.getType() == 9) {
                stringBuffer.append("(");
                continue;
            }
            if (tokenWithIndex.getType() == 38) {
                stringBuffer.append("{");
                stringBuffer.append(tokenWithIndex.getText());
                stringBuffer.append("}");
                continue;
            }
            if (tokenWithIndex.getType() == 69 || tokenWithIndex.getType() == 36 || tokenWithIndex.getType() == 35) {
                stringBuffer.append("{");
                stringBuffer.append(tokenWithIndex.getText());
                stringBuffer.append("}?");
                continue;
            }
            if (tokenWithIndex.getType() == 57) {
                stringBuffer.append("[");
                stringBuffer.append(tokenWithIndex.getText());
                stringBuffer.append("]");
                continue;
            }
            stringBuffer.append(tokenWithIndex.getText());
        }
        String string = stringBuffer.toString();
        this.lexerGrammarST.setAttribute("rules", (Object)string);
        this.lexerRules.add(token.getText());
    }

    public void defineLexerRuleForAliasedStringLiteral(String string, String string2, int n) {
        this.lexerGrammarST.setAttribute("literals.{ruleName,type,literal}", (Object)string, (Object)Utils.integer(n), (Object)string2);
        this.lexerRules.add(string);
    }

    public void defineLexerRuleForStringLiteral(String string, int n) {
        this.lexerGrammarST.setAttribute("literals.{ruleName,type,literal}", (Object)this.computeTokenNameFromLiteral(n, string), (Object)Utils.integer(n), (Object)string);
    }

    public Rule getRule(String string) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        return rule;
    }

    public int getRuleIndex(String string) {
        Rule rule = this.getRule(string);
        if (rule != null) {
            return rule.index;
        }
        return -1;
    }

    public String getRuleName(int n) {
        return (String)this.ruleIndexToRuleList.get(n);
    }

    public AttributeScope defineGlobalScope(String string, Token token) {
        AttributeScope attributeScope = new AttributeScope(this, string, token);
        this.scopes.put(string, attributeScope);
        return attributeScope;
    }

    public AttributeScope createReturnScope(String string, Token token) {
        AttributeScope attributeScope = new AttributeScope(this, string, token);
        attributeScope.isReturnScope = true;
        return attributeScope;
    }

    public AttributeScope createRuleScope(String string, Token token) {
        AttributeScope attributeScope = new AttributeScope(this, string, token);
        attributeScope.isDynamicRuleScope = true;
        return attributeScope;
    }

    public AttributeScope createParameterScope(String string, Token token) {
        AttributeScope attributeScope = new AttributeScope(this, string, token);
        attributeScope.isParameterScope = true;
        return attributeScope;
    }

    public AttributeScope getGlobalScope(String string) {
        return (AttributeScope)this.scopes.get(string);
    }

    public Map getGlobalScopes() {
        return this.scopes;
    }

    protected void defineLabel(Rule rule, Token token, GrammarAST grammarAST, int n) {
        boolean bl = this.nameSpaceChecker.checkForLabelTypeMismatch(rule, token, n);
        if (bl) {
            return;
        }
        rule.defineLabel(token, grammarAST, n);
    }

    public void defineTokenRefLabel(String string, Token token, GrammarAST grammarAST) {
        Rule rule = this.getRule(string);
        if (rule != null) {
            this.defineLabel(rule, token, grammarAST, 2);
        }
    }

    public void defineRuleRefLabel(String string, Token token, GrammarAST grammarAST) {
        Rule rule = this.getRule(string);
        if (rule != null) {
            this.defineLabel(rule, token, grammarAST, 1);
        }
    }

    public void defineTokenListLabel(String string, Token token, GrammarAST grammarAST) {
        Rule rule = this.getRule(string);
        if (rule != null) {
            this.defineLabel(rule, token, grammarAST, 4);
        }
    }

    public void defineRuleListLabel(String string, Token token, GrammarAST grammarAST) {
        Rule rule = this.getRule(string);
        if (rule != null) {
            if (!rule.getHasMultipleReturnValues()) {
                ErrorManager.grammarError(134, this, token, token.getText());
            }
            this.defineLabel(rule, token, grammarAST, 3);
        }
    }

    public void altReferencesRule(String string, GrammarAST grammarAST, int n) {
        Rule rule = this.getRule(string);
        if (rule == null) {
            return;
        }
        rule.trackRuleReferenceInAlt(grammarAST, n);
        Token token = grammarAST.getToken();
        if (!this.ruleRefs.contains(token)) {
            this.ruleRefs.add(token);
        }
    }

    public void altReferencesTokenID(String string, GrammarAST grammarAST, int n) {
        Rule rule = this.getRule(string);
        if (rule == null) {
            return;
        }
        rule.trackTokenReferenceInAlt(grammarAST, n);
        if (!this.tokenIDRefs.contains(grammarAST.getToken())) {
            this.tokenIDRefs.add(grammarAST.getToken());
        }
    }

    public void referenceRuleLabelPredefinedAttribute(String string) {
        Rule rule = this.getRule(string);
        if (rule != null && this.type != 1) {
            rule.referencedPredefinedRuleAttributes = true;
        }
    }

    public void checkRuleReference(GrammarAST grammarAST, GrammarAST grammarAST2, String string) {
        Rule rule = this.getRule(grammarAST.getText());
        if (grammarAST.getType() == 75) {
            if (grammarAST2 != null) {
                if (rule != null && rule.argActionAST == null) {
                    ErrorManager.grammarError(130, this, grammarAST2.getToken(), rule.name);
                }
            } else if (rule != null && rule.argActionAST != null) {
                ErrorManager.grammarError(129, this, grammarAST.getToken(), rule.name);
            }
        } else if (grammarAST.getType() == 52) {
            if (this.type != 1) {
                if (grammarAST2 != null) {
                    ErrorManager.grammarError(131, this, grammarAST.getToken(), grammarAST.getText());
                }
                return;
            }
            if (grammarAST2 != null) {
                if (rule != null && rule.argActionAST == null) {
                    ErrorManager.grammarError(130, this, grammarAST2.getToken(), rule.name);
                }
            } else if (rule != null && rule.argActionAST != null) {
                ErrorManager.grammarError(129, this, grammarAST.getToken(), rule.name);
            }
        }
    }

    public Set getLeftRecursiveRules() {
        if (this.nfa == null) {
            this.createNFAs();
        }
        if (this.leftRecursiveRules != null) {
            return this.leftRecursiveRules;
        }
        this.checkAllRulesForLeftRecursion();
        return this.leftRecursiveRules;
    }

    public List checkAllRulesForLeftRecursion() {
        this.createNFAs();
        this.leftRecursiveRules = new HashSet();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.ruleIndexToRuleList.size(); ++i) {
            String string = (String)this.ruleIndexToRuleList.elementAt(i);
            if (string == null) continue;
            NFAState nFAState = this.getRuleStartState(string);
            this.visitedDuringRecursionCheck = new HashSet();
            this.visitedDuringRecursionCheck.add(string);
            HashSet hashSet = new HashSet();
            this.traceStatesLookingForLeftRecursion(nFAState, hashSet, arrayList);
        }
        if (arrayList.size() > 0) {
            ErrorManager.leftRecursionCycles(arrayList);
        }
        return arrayList;
    }

    protected boolean traceStatesLookingForLeftRecursion(NFAState nFAState, Set set, List list) {
        Object object;
        if (nFAState.isAcceptState()) {
            return true;
        }
        if (set.contains(nFAState)) {
            return false;
        }
        set.add(nFAState);
        boolean bl = false;
        Transition transition = nFAState.transition(0);
        if (transition instanceof RuleClosureTransition) {
            object = ((NFAState)transition.target).getEnclosingRule();
            if (this.visitedDuringRecursionCheck.contains(object)) {
                this.leftRecursiveRules.add(object);
                this.addRulesToCycle((String)object, nFAState.getEnclosingRule(), list);
            } else {
                this.visitedDuringRecursionCheck.add(object);
                boolean bl2 = this.traceStatesLookingForLeftRecursion((NFAState)transition.target, new HashSet(), list);
                this.visitedDuringRecursionCheck.remove(object);
                if (bl2) {
                    NFAState nFAState2 = ((RuleClosureTransition)transition).getFollowState();
                    bl |= this.traceStatesLookingForLeftRecursion(nFAState2, set, list);
                }
            }
        } else if (transition.label.isEpsilon()) {
            bl |= this.traceStatesLookingForLeftRecursion((NFAState)transition.target, set, list);
        }
        object = nFAState.transition(1);
        if (object != null) {
            bl |= this.traceStatesLookingForLeftRecursion((NFAState)((Transition)object).target, set, list);
        }
        return bl;
    }

    protected void addRulesToCycle(String string, String string2, List list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Set set = (Set)list.get(i);
            if (set.contains(string)) {
                set.add(string2);
                bl = true;
            }
            if (!set.contains(string2)) continue;
            set.add(string);
            bl = true;
        }
        if (!bl) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            hashSet.add(string2);
            list.add(hashSet);
        }
    }

    public boolean isEmptyRule(GrammarAST grammarAST) {
        GrammarAST grammarAST2 = grammarAST.findFirstType(52);
        GrammarAST grammarAST3 = grammarAST.findFirstType(48);
        GrammarAST grammarAST4 = grammarAST.findFirstType(49);
        GrammarAST grammarAST5 = grammarAST.findFirstType(76);
        GrammarAST grammarAST6 = grammarAST.findFirstType(75);
        return grammarAST2 == null && grammarAST3 == null && grammarAST4 == null && grammarAST5 == null && grammarAST6 == null;
    }

    public int getTokenType(String string) {
        Integer n = null;
        n = string.charAt(0) == '\'' ? (Integer)this.stringLiteralToTypeMap.get(string) : (Integer)this.tokenIDToTypeMap.get(string);
        int n2 = n != null ? n : -6;
        return n2;
    }

    public Set getTokenIDs() {
        return this.tokenIDToTypeMap.keySet();
    }

    public Collection getTokenTypesWithoutID() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 4; i <= this.getMaxTokenType(); ++i) {
            String string = this.getTokenDisplayName(i);
            if (string.charAt(0) != '\'') continue;
            arrayList.add(Utils.integer(i));
        }
        return arrayList;
    }

    public Set getTokenDisplayNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 4; i <= this.getMaxTokenType(); ++i) {
            hashSet.add(this.getTokenDisplayName(i));
        }
        return hashSet;
    }

    public static int getCharValueFromGrammarCharLiteral(String string) {
        if (string.length() == 3) {
            return string.charAt(1);
        }
        if (string.length() == 4) {
            char c = string.charAt(2);
            int n = ANTLRLiteralEscapedCharValue[c];
            if (n == 0) {
                return c;
            }
            return n;
        }
        if (string.length() == 8) {
            String string2 = string.substring(3, string.length() - 1);
            return Integer.parseInt(string2, 16);
        }
        ErrorManager.assertTrue(false, "invalid char literal: " + string);
        return -1;
    }

    public static StringBuffer getUnescapedStringFromGrammarStringLiteral(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 1;
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (Character.toUpperCase(c = string.charAt(++i)) == 'U') {
                    String string2 = string.substring(++i, i + 4);
                    int n2 = Integer.parseInt(string2, 16);
                    i += 3;
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append((char)ANTLRLiteralEscapedCharValue[c]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public int importTokenVocabulary(Grammar grammar) {
        Set set = grammar.getTokenIDs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = grammar.getTokenType(string);
            this.maxTokenType = Math.max(this.maxTokenType, n);
            if (n < 4) continue;
            this.defineToken(string, n);
        }
        return this.maxTokenType;
    }

    public int importTokenVocabulary(String string) {
        String string2 = this.tool.getLibraryDirectory() + File.separator + string + ".tokens";
        try {
            BufferedReader bufferedReader = this.tool.getLibraryFile(string + ".tokens");
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.parseNumbers();
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.slashStarComments(true);
            streamTokenizer.ordinaryChar(61);
            streamTokenizer.quoteChar(39);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(9, 9);
            int n = 1;
            int n2 = streamTokenizer.nextToken();
            while (n2 != -1) {
                String string3;
                if (n2 == -3) {
                    string3 = streamTokenizer.sval;
                } else if (n2 == 39) {
                    string3 = "'" + streamTokenizer.sval + "'";
                } else {
                    ErrorManager.error(13, (Object)(string + ".tokens"), Utils.integer(n));
                    while (streamTokenizer.nextToken() != 10) {
                    }
                    n2 = streamTokenizer.nextToken();
                    continue;
                }
                n2 = streamTokenizer.nextToken();
                if (n2 != 61) {
                    ErrorManager.error(13, (Object)(string + ".tokens"), Utils.integer(n));
                    while (streamTokenizer.nextToken() != 10) {
                    }
                    n2 = streamTokenizer.nextToken();
                    continue;
                }
                n2 = streamTokenizer.nextToken();
                if (n2 != -2) {
                    ErrorManager.error(13, (Object)(string + ".tokens"), Utils.integer(n));
                    while (streamTokenizer.nextToken() != 10) {
                    }
                    n2 = streamTokenizer.nextToken();
                    continue;
                }
                int n3 = (int)streamTokenizer.nval;
                n2 = streamTokenizer.nextToken();
                this.maxTokenType = Math.max(this.maxTokenType, n3);
                this.defineToken(string3, n3);
                ++n;
                if (n2 != 10) {
                    ErrorManager.error(13, (Object)(string + ".tokens"), Utils.integer(n));
                    while (streamTokenizer.nextToken() != 10) {
                    }
                    n2 = streamTokenizer.nextToken();
                    continue;
                }
                n2 = streamTokenizer.nextToken();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorManager.error(3, string2);
        }
        catch (IOException iOException) {
            ErrorManager.error(4, (Object)string2, iOException);
        }
        catch (Exception exception) {
            ErrorManager.error(4, (Object)string2, exception);
        }
        return this.maxTokenType;
    }

    public String getTokenDisplayName(int n) {
        String string = null;
        int n2 = 0;
        if (this.type == 1 && n >= 0 && n <= 65534) {
            return Grammar.getANTLRCharLiteralForChar(n);
        }
        if (n < 0) {
            string = (String)this.typeToTokenList.get(6 + n);
        } else {
            n2 = n - 1;
            string = (n2 += 6) < this.typeToTokenList.size() ? (String)this.typeToTokenList.get(n2) : String.valueOf(n);
        }
        return string;
    }

    public Set getStringLiterals() {
        return this.stringLiteralToTypeMap.keySet();
    }

    public int getGrammarMaxLookahead() {
        if (this.global_k >= 0) {
            return this.global_k;
        }
        Object object = this.getOption("k");
        if (object == null) {
            this.global_k = 0;
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            this.global_k = n;
        } else if (object.equals("*")) {
            this.global_k = 0;
        }
        return this.global_k;
    }

    public String setOption(String string, Object object, Token token) {
        if (!legalOptions.contains(string)) {
            ErrorManager.grammarError(133, this, token, string);
            return null;
        }
        if (!this.optionIsValid(string, object)) {
            return null;
        }
        if (this.options == null) {
            this.options = new HashMap();
        }
        this.options.put(string, object);
        return string;
    }

    public void setOptions(Map map, Token token) {
        if (map == null) {
            this.options = null;
            return;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object v;
            String string = (String)iterator.next();
            String string2 = this.setOption(string, v = map.get(string), token);
            if (string2 != null) continue;
            iterator.remove();
        }
    }

    public Object getOption(String string) {
        Object var2_2 = null;
        if (this.options != null) {
            var2_2 = this.options.get(string);
        }
        if (var2_2 == null) {
            var2_2 = defaultOptions.get(string);
        }
        return var2_2;
    }

    public boolean optionIsValid(String string, Object object) {
        return true;
    }

    public boolean buildAST() {
        String string = (String)this.getOption("output");
        if (string != null) {
            return string.equals("AST");
        }
        return false;
    }

    public boolean isBuiltFromString() {
        return this.builtFromString;
    }

    public boolean buildTemplate() {
        String string = (String)this.getOption("output");
        if (string != null) {
            return string.equals("template");
        }
        return false;
    }

    public Collection getRules() {
        return this.nameToRuleMap.values();
    }

    public void setRuleAST(String string, GrammarAST grammarAST) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        if (rule != null) {
            rule.tree = grammarAST;
            rule.EORNode = grammarAST.getLastChild();
        }
    }

    public void setRuleStartState(String string, NFAState nFAState) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        if (rule != null) {
            rule.startState = nFAState;
        }
    }

    public void setRuleStopState(String string, NFAState nFAState) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        if (rule != null) {
            rule.stopState = nFAState;
        }
    }

    public NFAState getRuleStartState(String string) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        if (rule != null) {
            return rule.startState;
        }
        return null;
    }

    public String getRuleModifier(String string) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        if (rule != null) {
            return rule.modifier;
        }
        return null;
    }

    public NFAState getRuleStopState(String string) {
        Rule rule = (Rule)this.nameToRuleMap.get(string);
        if (rule != null) {
            return rule.stopState;
        }
        return null;
    }

    public int assignDecisionNumber(NFAState nFAState) {
        ++this.decisionNumber;
        nFAState.setDecisionNumber(this.decisionNumber);
        return this.decisionNumber;
    }

    protected Decision getDecision(int n) {
        int n2 = n - 1;
        if (n2 >= this.indexToDecision.size()) {
            return null;
        }
        Decision decision = (Decision)this.indexToDecision.get(n2);
        return decision;
    }

    protected Decision createDecision(int n) {
        int n2 = n - 1;
        if (n2 < this.indexToDecision.size()) {
            return this.getDecision(n);
        }
        Decision decision = new Decision();
        decision.decision = n;
        this.indexToDecision.setSize(this.getNumberOfDecisions());
        this.indexToDecision.set(n2, decision);
        return decision;
    }

    public List getDecisionNFAStartStateList() {
        ArrayList<NFAState> arrayList = new ArrayList<NFAState>(100);
        for (int i = 0; i < this.indexToDecision.size(); ++i) {
            Decision decision = (Decision)this.indexToDecision.elementAt(i);
            arrayList.add(decision.startState);
        }
        return arrayList;
    }

    public NFAState getDecisionNFAStartState(int n) {
        Decision decision = this.getDecision(n);
        if (decision == null) {
            return null;
        }
        return decision.startState;
    }

    public DFA getLookaheadDFA(int n) {
        Decision decision = this.getDecision(n);
        if (decision == null) {
            return null;
        }
        return decision.dfa;
    }

    public GrammarAST getDecisionBlockAST(int n) {
        Decision decision = this.getDecision(n);
        if (decision == null) {
            return null;
        }
        return decision.blockAST;
    }

    public List getLookaheadDFAColumnsForLineInFile(int n) {
        String string = n + ":";
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = this.lineColumnToLookaheadDFAMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            arrayList.add(Integer.valueOf(string2.substring(string.length())));
        }
        return arrayList;
    }

    public DFA getLookaheadDFAFromPositionInFile(int n, int n2) {
        return (DFA)this.lineColumnToLookaheadDFAMap.get(n + ":" + n2);
    }

    public int getNumberOfDecisions() {
        return this.decisionNumber;
    }

    public int getNumberOfCyclicDecisions() {
        int n = 0;
        for (int i = 1; i <= this.getNumberOfDecisions(); ++i) {
            Decision decision = this.getDecision(i);
            if (decision.dfa == null || !decision.dfa.isCyclic()) continue;
            ++n;
        }
        return n;
    }

    public void setLookaheadDFA(int n, DFA dFA) {
        Decision decision = this.createDecision(n);
        decision.dfa = dFA;
        GrammarAST grammarAST = decision.startState.getAssociatedASTNode();
        grammarAST.setLookaheadDFA(dFA);
    }

    public void setDecisionNFA(int n, NFAState nFAState) {
        Decision decision = this.createDecision(n);
        decision.startState = nFAState;
    }

    public void setDecisionBlockAST(int n, GrammarAST grammarAST) {
        Decision decision = this.createDecision(n);
        decision.blockAST = grammarAST;
    }

    public boolean allDecisionDFAHaveBeenCreated() {
        return this.allDecisionDFACreated;
    }

    public int getMaxTokenType() {
        return this.maxTokenType;
    }

    public int getMaxCharValue() {
        if (this.generator != null) {
            return this.generator.target.getMaxCharValue(this.generator);
        }
        return 65534;
    }

    public IntSet getTokenTypes() {
        if (this.type == 1) {
            return this.getAllCharValues();
        }
        return IntervalSet.of(4, this.getMaxTokenType());
    }

    public IntSet getAllCharValues() {
        if (this.charVocabulary != null) {
            return this.charVocabulary;
        }
        IntervalSet intervalSet = IntervalSet.of(0, this.getMaxCharValue());
        return intervalSet;
    }

    public static String getANTLRCharLiteralForChar(int n) {
        if (n < 0) {
            ErrorManager.internalError("invalid char value " + n);
            return "'<INVALID>'";
        }
        if (n < ANTLRLiteralCharValueEscape.length && ANTLRLiteralCharValueEscape[n] != null) {
            return '\'' + ANTLRLiteralCharValueEscape[n] + '\'';
        }
        if (Character.UnicodeBlock.of((char)n) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)n)) {
            if (n == 92) {
                return "'\\\\'";
            }
            if (n == 39) {
                return "'\\''";
            }
            return '\'' + Character.toString((char)n) + '\'';
        }
        String string = Integer.toHexString(n | 0x10000).toUpperCase().substring(1, 5);
        String string2 = "'\\u" + string + "'";
        return string2;
    }

    public IntSet complement(IntSet intSet) {
        IntSet intSet2 = intSet.complement(this.getTokenTypes());
        return intSet2;
    }

    public IntSet complement(int n) {
        return this.complement(IntervalSet.of(n));
    }

    public int getNumberOfAltsForDecisionNFA(NFAState nFAState) {
        if (nFAState == null) {
            return 0;
        }
        int n = 1;
        NFAState nFAState2 = nFAState;
        while (nFAState2.transition(1) != null) {
            ++n;
            nFAState2 = (NFAState)nFAState2.transition((int)1).target;
        }
        return n;
    }

    public NFAState getNFAStateForAltOfDecision(NFAState nFAState, int n) {
        if (nFAState == null || n <= 0) {
            return null;
        }
        int n2 = 1;
        NFAState nFAState2 = nFAState;
        while (nFAState2 != null) {
            if (n2 == n) {
                return nFAState2;
            }
            ++n2;
            Transition transition = nFAState2.transition(1);
            nFAState2 = null;
            if (transition == null) continue;
            nFAState2 = (NFAState)transition.target;
        }
        return null;
    }

    public LookaheadSet LOOK(NFAState nFAState) {
        this.lookBusy.clear();
        return this._LOOK(nFAState);
    }

    protected LookaheadSet _LOOK(NFAState nFAState) {
        LookaheadSet lookaheadSet;
        Transition transition;
        if (nFAState.isAcceptState()) {
            return new LookaheadSet(1);
        }
        if (this.lookBusy.contains(nFAState)) {
            return new LookaheadSet();
        }
        this.lookBusy.add(nFAState);
        Transition transition2 = nFAState.transition(0);
        if (transition2 == null) {
            return null;
        }
        if (transition2.label.isAtom()) {
            int n = transition2.label.getAtom();
            if (n == -1) {
                return LookaheadSet.EOF();
            }
            return new LookaheadSet(n);
        }
        if (transition2.label.isSet()) {
            IntSet intSet = transition2.label.getSet();
            LookaheadSet lookaheadSet2 = new LookaheadSet(intSet);
            if (lookaheadSet2.member(-1)) {
                lookaheadSet2.remove(-1);
                lookaheadSet2.hasEOF = true;
            }
            return lookaheadSet2;
        }
        LookaheadSet lookaheadSet3 = this._LOOK((NFAState)transition2.target);
        if (lookaheadSet3.member(1) && transition2 instanceof RuleClosureTransition) {
            transition = (RuleClosureTransition)transition2;
            lookaheadSet3.remove(1);
            lookaheadSet = this._LOOK(((RuleClosureTransition)transition).getFollowState());
            lookaheadSet3.orInPlace(lookaheadSet);
        }
        if ((transition = nFAState.transition(1)) != null) {
            lookaheadSet = this._LOOK((NFAState)transition.target);
            lookaheadSet3.orInPlace(lookaheadSet);
        }
        return lookaheadSet3;
    }

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.generator = codeGenerator;
    }

    public CodeGenerator getCodeGenerator() {
        return this.generator;
    }

    public GrammarAST getGrammarTree() {
        return this.grammarTree;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public String computeTokenNameFromLiteral(int n, String string) {
        return "T" + n;
    }

    public String toString() {
        return this.grammarTreeToString(this.grammarTree);
    }

    public String grammarTreeToString(GrammarAST grammarAST) {
        return this.grammarTreeToString(grammarAST, true);
    }

    public String grammarTreeToString(GrammarAST grammarAST, boolean bl) {
        String string = null;
        try {
            string = grammarAST.getLine() + ":" + grammarAST.getColumn() + ": ";
            string = string + new ANTLRTreePrinter().toString((AST)grammarAST, this, bl);
        }
        catch (Exception exception) {
            ErrorManager.error(15, (Object)grammarAST, exception);
        }
        return string;
    }

    public void setWatchNFAConversion(boolean bl) {
        this.watchNFAConversion = bl;
    }

    public boolean getWatchNFAConversion() {
        return this.watchNFAConversion;
    }

    public void printGrammar(PrintStream printStream) {
        ANTLRTreePrinter aNTLRTreePrinter = new ANTLRTreePrinter();
        aNTLRTreePrinter.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            String string = aNTLRTreePrinter.toString((AST)this.grammarTree, this, false);
            printStream.println(string);
        }
        catch (RecognitionException recognitionException) {
            ErrorManager.error(100, recognitionException);
        }
    }

    static {
        Grammar.ANTLRLiteralEscapedCharValue[110] = 10;
        Grammar.ANTLRLiteralEscapedCharValue[114] = 13;
        Grammar.ANTLRLiteralEscapedCharValue[116] = 9;
        Grammar.ANTLRLiteralEscapedCharValue[98] = 8;
        Grammar.ANTLRLiteralEscapedCharValue[102] = 12;
        Grammar.ANTLRLiteralEscapedCharValue[92] = 92;
        Grammar.ANTLRLiteralEscapedCharValue[39] = 39;
        Grammar.ANTLRLiteralEscapedCharValue[34] = 34;
        Grammar.ANTLRLiteralCharValueEscape[10] = "\\n";
        Grammar.ANTLRLiteralCharValueEscape[13] = "\\r";
        Grammar.ANTLRLiteralCharValueEscape[9] = "\\t";
        Grammar.ANTLRLiteralCharValueEscape[8] = "\\b";
        Grammar.ANTLRLiteralCharValueEscape[12] = "\\f";
        Grammar.ANTLRLiteralCharValueEscape[92] = "\\\\";
        Grammar.ANTLRLiteralCharValueEscape[39] = "\\'";
        grammarTypeToString = new String[]{"<invalid>", "lexer", "parser", "tree", "combined"};
        grammarTypeToFileNameSuffix = new String[]{"<invalid>", "Lexer", "Parser", "TreeParser", "Parser"};
        legalOptions = new HashSet(){
            {
                this.add("language");
                this.add("tokenVocab");
                this.add("output");
                this.add("ASTLabelType");
                this.add("TokenLabelType");
                this.add("superClass");
                this.add("filter");
                this.add("k");
                this.add("backtrack");
                this.add("memoize");
            }
        };
        doNotCopyOptionsToLexer = new HashSet(){
            {
                this.add("output");
                this.add("ASTLabelType");
                this.add("superClass");
                this.add("k");
                this.add("backtrack");
                this.add("memoize");
            }
        };
        defaultOptions = new HashMap(){
            {
                this.put("language", "Java");
            }
        };
    }

    public class LabelElementPair {
        public Token label;
        public GrammarAST elementRef;
        public String referencedRuleName;
        public int type;

        public LabelElementPair(Token token, GrammarAST grammarAST) {
            this.label = token;
            this.elementRef = grammarAST;
            this.referencedRuleName = grammarAST.getText();
        }

        public Rule getReferencedRule() {
            return Grammar.this.getRule(this.referencedRuleName);
        }

        public String toString() {
            return this.elementRef.toString();
        }
    }

    public static class Decision {
        public int decision;
        public NFAState startState;
        public GrammarAST blockAST;
        public DFA dfa;
    }
}

