/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter;

import de.cenote.jasperstarter.Config;
import de.cenote.jasperstarter.Report;
import de.cenote.jasperstarter.types.AskFilter;
import de.cenote.jasperstarter.types.Command;
import de.cenote.jasperstarter.types.DsType;
import de.cenote.jasperstarter.types.OutputFormat;
import de.cenote.tools.classpath.ApplicationClasspath;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class App {
    private Namespace namespace = null;
    private Map<String, Argument> allArguments = null;
    private static PrintStream configSink = System.err;
    private static PrintStream debugSink = System.err;
    private static PrintStream errSink = System.err;

    public static void main(String[] args) {
        Config config = new Config();
        App app = new App();
        ArgumentParser parser = app.createArgumentParser(config);
        if (args.length == 0) {
            System.out.println(parser.formatUsage());
            System.out.println("type: jasperstarter -h to get help");
            System.exit(0);
        }
        try {
            app.parseArgumentParser(args, parser, config);
        }
        catch (ArgumentParserException ex) {
            parser.handleError(ex);
            System.exit(1);
        }
        if (config.isVerbose()) {
            configSink.print("Command line:");
            for (String arg : args) {
                configSink.print(" " + arg);
            }
        }
        if (config.hasLocale()) {
            Locale.setDefault(config.getLocale());
        }
        try {
            switch (Command.getCommand(config.getCommand())) {
                case COMPILE: 
                case CP: {
                    app.compile(config);
                    break;
                }
                case PROCESS: 
                case PR: {
                    app.processReport(config);
                    break;
                }
                case LIST_PRINTERS: 
                case PRINTERS: 
                case LPR: {
                    app.listPrinters();
                    break;
                }
                case LIST_PARAMETERS: 
                case PARAMS: 
                case LPA: {
                    App.listReportParams(config, new File(config.getInput()).getAbsoluteFile());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            errSink.println(ex.getMessage());
            System.exit(1);
        }
        catch (InterruptedException ex) {
            errSink.println(ex.getMessage());
            Thread.currentThread().interrupt();
            System.exit(1);
        }
        catch (JRException ex) {
            errSink.println(ex.getMessage());
            System.exit(1);
        }
    }

    private void compile(Config config) {
        IllegalArgumentException error = null;
        File input = new File(config.getInput());
        if (input.isFile()) {
            try {
                Report report = new Report(config, input);
                report.compileToFile();
            }
            catch (IllegalArgumentException ex) {
                error = ex;
            }
        } else if (input.isDirectory()) {
            File[] files;
            WildcardFileFilter fileFilter = new WildcardFileFilter("*.jrxml", IOCase.INSENSITIVE);
            for (File file : files = input.listFiles((FileFilter)fileFilter)) {
                try {
                    System.out.println("Compiling: \"" + file + "\"");
                    Report report = new Report(config, file);
                    report.compileToFile();
                }
                catch (IllegalArgumentException ex) {
                    error = ex;
                }
            }
        } else {
            error = new IllegalArgumentException("Error: not a file: " + input.getName());
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processReport(Config config) throws IllegalArgumentException, InterruptedException, JRException {
        try {
            if (config.hasJdbcDir()) {
                File jdbcDir = config.getJdbcDir();
                if (config.isVerbose()) {
                    configSink.println("Using jdbc-dir: " + jdbcDir.getAbsolutePath());
                }
                ApplicationClasspath.addJars(jdbcDir.getAbsolutePath());
            } else {
                ApplicationClasspath.addJarsRelative("../jdbc");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error adding jdbc-dir", ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Error adding jdbc-dir: \"../jdbc\"", ex);
        }
        if (config.hasResource()) {
            try {
                File res;
                if ("".equals(config.getResource())) {
                    res = new File(config.getInput()).getAbsoluteFile().getParentFile();
                    if (!res.isDirectory()) throw new IllegalArgumentException("Resource path \"" + res + "\" is not a directory");
                    ApplicationClasspath.add(res);
                    if (config.isVerbose()) {
                        configSink.println("Added resource \"" + res + "\" to classpath");
                    }
                } else {
                    res = new File(config.getResource());
                    ApplicationClasspath.add(res);
                    if (config.isVerbose()) {
                        configSink.println("Added resource \"" + res + "\" to classpath");
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Error adding resource \"" + config.getResource() + "\" to classpath", ex);
            }
        }
        File inputFile = new File(config.getInput()).getAbsoluteFile();
        if (config.isVerbose()) {
            configSink.println("Original input file: " + inputFile.getAbsolutePath());
        }
        inputFile = this.locateInputFile(inputFile);
        if (config.isVerbose()) {
            configSink.println("Using input file: " + inputFile.getAbsolutePath());
        }
        Report report = new Report(config, inputFile);
        report.fill();
        List<OutputFormat> formats = config.getOutputFormats();
        Boolean viewIt = false;
        Boolean printIt = false;
        if (formats.size() > 1 && config.getOutput().equals("-")) {
            throw new IllegalArgumentException("output file \"-\" cannot be used with multiple output formats: " + formats);
        }
        for (OutputFormat f : formats) {
            if (OutputFormat.print.equals((Object)f)) {
                printIt = true;
                continue;
            }
            if (OutputFormat.view.equals((Object)f)) {
                viewIt = true;
                continue;
            }
            if (OutputFormat.pdf.equals((Object)f)) {
                report.exportPdf();
                continue;
            }
            if (OutputFormat.docx.equals((Object)f)) {
                report.exportDocx();
                continue;
            }
            if (OutputFormat.odt.equals((Object)f)) {
                report.exportOdt();
                continue;
            }
            if (OutputFormat.rtf.equals((Object)f)) {
                report.exportRtf();
                continue;
            }
            if (OutputFormat.html.equals((Object)f)) {
                report.exportHtml();
                continue;
            }
            if (OutputFormat.xml.equals((Object)f)) {
                report.exportXml();
                continue;
            }
            if (OutputFormat.xls.equals((Object)f)) {
                report.exportXls();
                continue;
            }
            if (OutputFormat.xlsMeta.equals((Object)f)) {
                report.exportXlsMeta();
                continue;
            }
            if (OutputFormat.xlsx.equals((Object)f)) {
                report.exportXlsx();
                continue;
            }
            if (OutputFormat.csv.equals((Object)f)) {
                report.exportCsv();
                continue;
            }
            if (OutputFormat.csvMeta.equals((Object)f)) {
                report.exportCsvMeta();
                continue;
            }
            if (OutputFormat.ods.equals((Object)f)) {
                report.exportOds();
                continue;
            }
            if (OutputFormat.pptx.equals((Object)f)) {
                report.exportPptx();
                continue;
            }
            if (OutputFormat.xhtml.equals((Object)f)) {
                report.exportXhtml();
                continue;
            }
            if (!OutputFormat.jrprint.equals((Object)f)) throw new IllegalArgumentException("Error output format \"" + (Object)((Object)f) + "\" not implemented!");
            report.exportJrprint();
        }
        if (viewIt.booleanValue()) {
            report.view();
            return;
        } else {
            if (!printIt.booleanValue()) return;
            report.print();
        }
    }

    private File locateInputFile(File inputFile) {
        if (!inputFile.exists()) {
            File newInputfile = new File(inputFile.getAbsolutePath() + ".jasper");
            if (newInputfile.isFile()) {
                inputFile = newInputfile;
            }
            if (!inputFile.exists() && (newInputfile = new File(inputFile.getAbsolutePath() + ".jrxml")).isFile()) {
                inputFile = newInputfile;
            }
        }
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("Error: file not found: " + inputFile.getAbsolutePath());
        }
        if (inputFile.isDirectory()) {
            throw new IllegalArgumentException("Error: " + inputFile.getAbsolutePath() + " is a directory, file needed");
        }
        return inputFile;
    }

    private void listPrinters() {
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        System.out.println("Default printer:");
        System.out.println("-----------------");
        System.out.println(defaultService == null ? "--- not set ---" : defaultService.getName());
        System.out.println("");
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        System.out.println("Available printers:");
        System.out.println("--------------------");
        for (PrintService service : services) {
            System.out.println(service.getName());
        }
    }

    private ArgumentParser createArgumentParser(Config config) {
        this.allArguments = new HashMap<String, Argument>();
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"jasperstarter", (boolean)false, (String)"-", (String)"@").version(config.getVersionString());
        parser.addArgument(new String[]{"-h", "--help"}).action((ArgumentAction)Arguments.help()).help("show this help message and exit");
        parser.addArgument(new String[]{"--locale"}).dest("locale").metavar(new String[]{"<lang>"}).help("set locale with two-letter ISO-639 code or a combination of ISO-639 and ISO-3166 like de_DE");
        parser.addArgument(new String[]{"-v", "--verbose"}).dest("debug").action((ArgumentAction)Arguments.storeTrue()).help("display additional messages");
        parser.addArgument(new String[]{"-V", "--version"}).action((ArgumentAction)Arguments.version()).help("display version information and exit");
        Subparsers subparsers = parser.addSubparsers().title("commands").help("type <cmd> -h to get help on command").metavar("<cmd>").dest("command");
        Subparser parserCompile = subparsers.addParser("compile", true).aliases(new String[]{"cp"}).help("compile reports");
        this.createCompileArguments(parserCompile);
        Subparser parserProcess = subparsers.addParser("process", true).aliases(new String[]{"pr"}).help("view, print or export an existing report");
        this.createProcessArguments(parserProcess);
        Subparser parserListPrinters = subparsers.addParser("list_printers", true).aliases(new String[]{"printers", "lpr"}).help("lists available printers");
        Subparser parserListParams = subparsers.addParser("list_parameters", true).aliases(new String[]{"params", "lpa"}).help("list parameters from a given report");
        this.createListParamsArguments(parserListParams);
        return parser;
    }

    private void createCompileArguments(Subparser parser) {
        ArgumentGroup groupOptions = parser.addArgumentGroup("options");
        groupOptions.addArgument(new String[]{"input"}).metavar(new String[]{"<input>"}).dest("input").required(true).help("input file (.jrxml) or directory");
        groupOptions.addArgument(new String[]{"-o"}).metavar(new String[]{"<output>"}).dest("output").help("directory or basename of outputfile(s)");
    }

    private void createListParamsArguments(Subparser parser) {
        ArgumentGroup groupOptions = parser.addArgumentGroup("options");
        groupOptions.addArgument(new String[]{"input"}).metavar(new String[]{"<input>"}).dest("input").required(true).help("input file (.jrxml) or (.jasper)");
    }

    private void createProcessArguments(Subparser parser) {
        ArgumentGroup groupOptions = parser.addArgumentGroup("options");
        groupOptions.addArgument(new String[]{"-f"}).metavar(new String[]{"<fmt>"}).dest("output-formats").required(true).nargs("+").type((ArgumentType)Arguments.enumType(OutputFormat.class)).help("view, print, pdf, rtf, xls, xlsMeta, xlsx, docx, odt, ods, pptx, csv, csvMeta, html, xhtml, xml, jrprint");
        groupOptions.addArgument(new String[]{"input"}).metavar(new String[]{"<input>"}).dest("input").required(true).help("input file (.jrxml|.jasper|.jrprint)");
        groupOptions.addArgument(new String[]{"-o"}).metavar(new String[]{"<output>"}).dest("output").help("directory or basename of outputfile(s), use '-' for stdout");
        ArgumentGroup groupCompileOptions = parser.addArgumentGroup("compile options");
        groupCompileOptions.addArgument(new String[]{"-w", "--write-jasper"}).dest("write-jasper").action((ArgumentAction)Arguments.storeTrue()).help("write .jasper file to imput dir if jrxml is processed");
        ArgumentGroup groupFillOptions = parser.addArgumentGroup("fill options");
        groupFillOptions.addArgument(new String[]{"-a"}).metavar(new String[]{"<filter>"}).dest("ask").type((ArgumentType)Arguments.enumType(AskFilter.class)).nargs("?").setConst((Object)AskFilter.p).help("ask for report parameters. Filter: a, ae, u, ue, p, pe (see usage)");
        groupFillOptions.addArgument(new String[]{"-P"}).metavar(new String[]{"<param>"}).dest("params").nargs("+").help("report parameter: name=value [...]");
        groupFillOptions.addArgument(new String[]{"-r"}).metavar(new String[]{"<resource>"}).dest("resource").nargs("?").setConst((Object)"").help("path to report resource dir or jar file. If <resource> is not given the input directory is used.");
        ArgumentGroup groupDatasourceOptions = parser.addArgumentGroup("datasource options");
        groupDatasourceOptions.addArgument(new String[]{"-t"}).metavar(new String[]{"<dstype>"}).dest("db-type").required(false).type((ArgumentType)Arguments.enumType(DsType.class)).setDefault((Object)DsType.none).help("datasource type: none, csv, xml, json, jsonql, mysql, postgres, oracle, generic (jdbc)");
        Argument argDbHost = groupDatasourceOptions.addArgument(new String[]{"-H"}).metavar(new String[]{"<dbhost>"}).dest("db-host").help("database host");
        Argument argDbUser = groupDatasourceOptions.addArgument(new String[]{"-u"}).metavar(new String[]{"<dbuser>"}).dest("db-user").help("database user");
        Argument argDbPasswd = groupDatasourceOptions.addArgument(new String[]{"-p"}).metavar(new String[]{"<dbpasswd>"}).dest("db-passwd").setDefault((Object)"").help("database password");
        Argument argDbName = groupDatasourceOptions.addArgument(new String[]{"-n"}).metavar(new String[]{"<dbname>"}).dest("db-name").help("database name");
        Argument argDbSid = groupDatasourceOptions.addArgument(new String[]{"--db-sid"}).metavar(new String[]{"<sid>"}).dest("db-sid").help("oracle sid");
        Argument argDbPort = groupDatasourceOptions.addArgument(new String[]{"--db-port"}).metavar(new String[]{"<port>"}).dest("db-port").type(Integer.class).help("database port");
        Argument argDbDriver = groupDatasourceOptions.addArgument(new String[]{"--db-driver"}).metavar(new String[]{"<name>"}).dest("db-driver").help("jdbc driver class name for use with type: generic");
        Argument argDbUrl = groupDatasourceOptions.addArgument(new String[]{"--db-url"}).metavar(new String[]{"<jdbcUrl>"}).dest("db-url").help("jdbc url without user, passwd with type:generic");
        groupDatasourceOptions.addArgument(new String[]{"--jdbc-dir"}).metavar(new String[]{"<dir>"}).dest("jdbc-dir").type(File.class).help("directory where jdbc driver jars are located. Defaults to ./jdbc");
        Argument argDataFile = groupDatasourceOptions.addArgument(new String[]{"--data-file"}).metavar(new String[]{"<file>"}).dest("data-file").type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead()).help("input file for file based datasource, use '-' for stdin");
        groupDatasourceOptions.addArgument(new String[]{"--csv-first-row"}).metavar(new String[]{"true", "false"}).dest("csv-first-row").action((ArgumentAction)Arguments.storeTrue()).help("first row contains column headers");
        Argument argCsvColumns = groupDatasourceOptions.addArgument(new String[]{"--csv-columns"}).metavar(new String[]{"<list>"}).dest("csv-columns").help("Comma separated list of column names");
        groupDatasourceOptions.addArgument(new String[]{"--csv-record-del"}).metavar(new String[]{"<delimiter>"}).dest("csv-record-del").setDefault((Object)System.getProperty("line.separator")).help("CSV Record Delimiter - defaults to line.separator");
        groupDatasourceOptions.addArgument(new String[]{"--csv-field-del"}).metavar(new String[]{"<delimiter>"}).dest("csv-field-del").setDefault((Object)",").help("CSV Field Delimiter - defaults to \",\"");
        groupDatasourceOptions.addArgument(new String[]{"--csv-charset"}).metavar(new String[]{"<charset>"}).dest("csv-charset").setDefault((Object)"utf-8").help("CSV charset - defaults to \"utf-8\"");
        Argument argXmlXpath = groupDatasourceOptions.addArgument(new String[]{"--xml-xpath"}).metavar(new String[]{"<xpath>"}).dest("xml-xpath").help("XPath for XML Datasource");
        Argument argJsonQuery = groupDatasourceOptions.addArgument(new String[]{"--json-query"}).metavar(new String[]{"<jsonquery>"}).dest("json-query").help("JSON query string for JSON Datasource");
        Argument argJsonQLQuery = groupDatasourceOptions.addArgument(new String[]{"--jsonql-query"}).metavar(new String[]{"<jsonqlquery>"}).dest("jsonql-query").help("JSONQL query string for JSONQL Datasource");
        ArgumentGroup groupOutputOptions = parser.addArgumentGroup("output options");
        groupOutputOptions.addArgument(new String[]{"-N"}).metavar(new String[]{"<printername>"}).dest("printer-name").help("name of printer");
        groupOutputOptions.addArgument(new String[]{"-d"}).dest("with-print-dialog").action((ArgumentAction)Arguments.storeTrue()).help("show print dialog when printing");
        groupOutputOptions.addArgument(new String[]{"-s"}).metavar(new String[]{"<reportname>"}).dest("set-report-name").help("set internal report/document name when printing");
        groupOutputOptions.addArgument(new String[]{"-c"}).metavar(new String[]{"<copies>"}).dest("copies").type(Integer.class).choices((ArgumentChoice)Arguments.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).help("number of copies. Defaults to 1");
        groupOutputOptions.addArgument(new String[]{"--out-field-del"}).metavar(new String[]{"<delimiter>"}).dest("out-field-del").setDefault((Object)",").help("Export CSV (Metadata) Field Delimiter - defaults to \",\"");
        groupOutputOptions.addArgument(new String[]{"--out-charset"}).metavar(new String[]{"<charset>"}).dest("out-charset").setDefault((Object)"utf-8").help("Export CSV (Metadata) Charset - defaults to \"utf-8\"");
        this.allArguments.put(argDbHost.getDest(), argDbHost);
        this.allArguments.put(argDbUser.getDest(), argDbUser);
        this.allArguments.put(argDbPasswd.getDest(), argDbPasswd);
        this.allArguments.put(argDbName.getDest(), argDbName);
        this.allArguments.put(argDbSid.getDest(), argDbSid);
        this.allArguments.put(argDbPort.getDest(), argDbPort);
        this.allArguments.put(argDbDriver.getDest(), argDbDriver);
        this.allArguments.put(argDbUrl.getDest(), argDbUrl);
        this.allArguments.put(argDataFile.getDest(), argDataFile);
        this.allArguments.put(argCsvColumns.getDest(), argCsvColumns);
        this.allArguments.put(argXmlXpath.getDest(), argXmlXpath);
        this.allArguments.put(argJsonQuery.getDest(), argJsonQuery);
        this.allArguments.put(argJsonQLQuery.getDest(), argJsonQLQuery);
    }

    private void parseArgumentParser(String[] args, ArgumentParser parser, Config config) throws ArgumentParserException {
        parser.parseArgs(args, (Object)config);
        if (config.hasDbType() && !config.getDbType().equals((Object)DsType.none)) {
            if (config.getDbType().equals((Object)DsType.mysql)) {
                this.allArguments.get("db-host").required(true);
                this.allArguments.get("db-user").required(true);
                this.allArguments.get("db-name").required(true);
                this.allArguments.get("db-port").setDefault((Object)DsType.mysql.getPort());
            } else if (config.getDbType().equals((Object)DsType.postgres)) {
                this.allArguments.get("db-host").required(true);
                this.allArguments.get("db-user").required(true);
                this.allArguments.get("db-name").required(true);
                this.allArguments.get("db-port").setDefault((Object)DsType.postgres.getPort());
            } else if (config.getDbType().equals((Object)DsType.oracle)) {
                this.allArguments.get("db-host").required(true);
                this.allArguments.get("db-user").required(true);
                this.allArguments.get("db-passwd").required(true);
                this.allArguments.get("db-sid").required(true);
                this.allArguments.get("db-port").setDefault((Object)DsType.oracle.getPort());
            } else if (config.getDbType().equals((Object)DsType.generic)) {
                this.allArguments.get("db-driver").required(true);
                this.allArguments.get("db-url").required(true);
            } else if (DsType.csv.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
                if (!config.getCsvFirstRow()) {
                    this.allArguments.get("csv-columns").required(true);
                }
            } else if (DsType.xml.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
            } else if (DsType.json.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
            } else if (DsType.jsonql.equals((Object)config.getDbType())) {
                this.allArguments.get("data-file").required(true);
            }
        }
        parser.parseArgs(args, (Object)config);
    }

    public static void listReportParams(Config config, File input) throws IllegalArgumentException {
        Report report = new Report(config, input);
        JRParameter[] params = report.getReportParameters();
        int maxName = 1;
        int maxClassName = 1;
        int maxDesc = 1;
        boolean all = false;
        for (JRParameter param : params) {
            if (param.isSystemDefined() && !all) continue;
            if (param.getName() != null) {
                maxName = Math.max(maxName, param.getName().length());
            }
            if (param.getValueClassName() != null) {
                maxClassName = Math.max(maxClassName, param.getValueClassName().length());
            }
            if (param.getDescription() == null) continue;
            maxDesc = Math.max(maxDesc, param.getDescription().length());
        }
        for (JRParameter param : params) {
            if (param.isSystemDefined() && !all) continue;
            System.out.printf("%s %-" + maxName + "s %-" + maxClassName + "s %-" + maxDesc + "s %n", param.isForPrompting() ? "P" : "N", param.getName(), param.getValueClassName(), param.getDescription() != null ? param.getDescription() : "");
        }
    }
}

