/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.eac.jcajce;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.python.bouncycastle.asn1.eac.ECDSAPublicKey;
import org.python.bouncycastle.asn1.eac.PublicKeyDataObject;
import org.python.bouncycastle.asn1.eac.RSAPublicKey;
import org.python.bouncycastle.eac.EACException;
import org.python.bouncycastle.eac.jcajce.DefaultEACHelper;
import org.python.bouncycastle.eac.jcajce.EACHelper;
import org.python.bouncycastle.eac.jcajce.NamedEACHelper;
import org.python.bouncycastle.eac.jcajce.ProviderEACHelper;
import org.python.bouncycastle.jce.spec.ECPublicKeySpec;
import org.python.bouncycastle.math.ec.ECCurve;
import org.python.bouncycastle.math.ec.ECPoint;

public class JcaPublicKeyConverter {
    private EACHelper helper = new DefaultEACHelper();

    public JcaPublicKeyConverter setProvider(String string) {
        this.helper = new NamedEACHelper(string);
        return this;
    }

    public JcaPublicKeyConverter setProvider(Provider provider) {
        this.helper = new ProviderEACHelper(provider);
        return this;
    }

    public PublicKey getKey(PublicKeyDataObject publicKeyDataObject) throws EACException, InvalidKeySpecException {
        if (publicKeyDataObject.getUsage().on(EACObjectIdentifiers.id_TA_ECDSA)) {
            return this.getECPublicKeyPublicKey((ECDSAPublicKey)publicKeyDataObject);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKeyDataObject;
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        try {
            KeyFactory keyFactory = this.helper.createKeyFactory("RSA");
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new EACException("cannot find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EACException("cannot find algorithm ECDSA: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    private PublicKey getECPublicKeyPublicKey(ECDSAPublicKey eCDSAPublicKey) throws EACException, InvalidKeySpecException {
        KeyFactory keyFactory;
        org.python.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = this.getParams(eCDSAPublicKey);
        ECCurve eCCurve = eCParameterSpec.getCurve();
        ECPoint eCPoint = eCCurve.decodePoint(eCDSAPublicKey.getPublicPointY());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        try {
            keyFactory = this.helper.createKeyFactory("ECDSA");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new EACException("cannot find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EACException("cannot find algorithm ECDSA: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        return keyFactory.generatePublic(eCPublicKeySpec);
    }

    private org.python.bouncycastle.jce.spec.ECParameterSpec getParams(ECDSAPublicKey eCDSAPublicKey) {
        if (!eCDSAPublicKey.hasParameters()) {
            throw new IllegalArgumentException("Public key does not contains EC Params");
        }
        BigInteger bigInteger = eCDSAPublicKey.getPrimeModulusP();
        ECCurve.Fp fp = new ECCurve.Fp(bigInteger, eCDSAPublicKey.getFirstCoefA(), eCDSAPublicKey.getSecondCoefB());
        ECPoint eCPoint = fp.decodePoint(eCDSAPublicKey.getBasePointG());
        BigInteger bigInteger2 = eCDSAPublicKey.getOrderOfBasePointR();
        BigInteger bigInteger3 = eCDSAPublicKey.getCofactorF();
        org.python.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = new org.python.bouncycastle.jce.spec.ECParameterSpec(fp, eCPoint, bigInteger2, bigInteger3);
        return eCParameterSpec;
    }

    public PublicKeyDataObject getPublicKeyDataObject(ASN1ObjectIdentifier aSN1ObjectIdentifier, PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
            return new RSAPublicKey(aSN1ObjectIdentifier, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        return new ECDSAPublicKey(aSN1ObjectIdentifier, ((ECFieldFp)eCParameterSpec.getCurve().getField()).getP(), eCParameterSpec.getCurve().getA(), eCParameterSpec.getCurve().getB(), JcaPublicKeyConverter.convertPoint(JcaPublicKeyConverter.convertCurve(eCParameterSpec.getCurve()), eCParameterSpec.getGenerator(), false).getEncoded(), eCParameterSpec.getOrder(), JcaPublicKeyConverter.convertPoint(JcaPublicKeyConverter.convertCurve(eCParameterSpec.getCurve()), eCPublicKey.getW(), false).getEncoded(), eCParameterSpec.getCofactor());
    }

    private static ECPoint convertPoint(ECCurve eCCurve, java.security.spec.ECPoint eCPoint, boolean bl) {
        return eCCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY(), bl);
    }

    private static ECCurve convertCurve(EllipticCurve ellipticCurve) {
        ECField eCField = ellipticCurve.getField();
        BigInteger bigInteger = ellipticCurve.getA();
        BigInteger bigInteger2 = ellipticCurve.getB();
        if (eCField instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)eCField).getP(), bigInteger, bigInteger2);
        }
        throw new IllegalStateException("not implemented yet!!!");
    }
}

