<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Log;

/**
 * Class BondDesign
 * @package App\Models
 * @version November 9, 2019, 6:22 pm UTC
 *
 */
class BondRecipeProductionStatus extends Model
{
 

    public $table = 'bond_recipe_production_status';

    protected $primaryKey = 'material_id';

    public $fillable = [
        'material_id',
        'status_id',
        'created_by'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
    ];

    public static function updateProductionStatus($materialId, $status){
        Log::info('materialId '. $materialId.' status '.$status);
        $prodStatus = ProductionStatus::where('tag','=', $status)->first();
        Log::info(' status '.$prodStatus);
        BondRecipeProductionStatus::create([
            'material_id' => $materialId,
            'status_id' => $prodStatus->id,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);
    }

    public function status(){
        return $this->belongsTo('App\Models\ProductionStatus','status_id');
    }
    
}
