<?php

namespace App\Repositories;

use App\Models\AccountGroup;
use App\Repositories\BaseRepository;

/**
 * Class AccountGroupRepository
 * @package App\Repositories
 * @version November 18, 2019, 6:45 pm UTC
*/

class AccountGroupRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'bond_name',
        'phone',
        'username',
        'email',
        'status'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return AccountGroup::class;
    }
}
