<?php

namespace App\Repositories;

use App\Models\EntryType;
use App\Repositories\BaseRepository;

/**
 * Class EntryTypeRepository
 * @package App\Repositories
 * @version November 26, 2019, 3:35 am UTC
*/

class EntryTypeRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'name'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return EntryType::class;
    }
}
