<?php

namespace App\Http\Controllers\API;

use App\Http\Requests\API\CreateAccountAPIRequest;
use App\Http\Requests\API\UpdateAccountAPIRequest;
use App\Models\Account;
use App\Repositories\AccountRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\AppBaseController;
use Response;

/**
 * Class AccountController
 * @package App\Http\Controllers\API
 */

class AccountAPIController extends AppBaseController
{
    /** @var  AccountRepository */
    private $accountRepository;

    public function __construct(AccountRepository $accountRepo)
    {
        $this->accountRepository = $accountRepo;
    }

    /**
     * Display a listing of the Account.
     * GET|HEAD /accounts
     *
     * @param Request $request
     * @return Response
     */
    public function listPaginate($type =null)
    {
        $accounts = null;
        if(!empty($type)){
            $accounts = Account::where('group_id','=', $type)->orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));    
        }else{
            $accounts = Account::orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
        }
        return  new \App\Http\Resources\BasePaginationResourceCollection($accounts, collect($accounts->items()), \App\Http\Resources\Account\AccountResource::class);
    }

    public function searchAccount(Request $request)
    {
        $query = $request->get('query');
        $type = $request->get('type');
        $accounts = null;
        if(!empty($type) && !empty($query)){
            $accounts = Account::where([['group_id','=', $type],['name','LIKE', '%'.$query.'%']])->orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));    
        }elseif(!empty($query)){
            $accounts = Account::where('name','LIKE', '%'.$query.'%')->orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
        }else if(!empty($type)){
            $accounts = Account::where('group_id','=', $type)->orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
        }else{
            $accounts = Account::orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
        }
        return  new \App\Http\Resources\BasePaginationResourceCollection($accounts, collect($accounts->items()), \App\Http\Resources\Account\AccountResource::class);
    }
}
