<?php 

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\ConsumableItem;

class ConsumableSettingsDetailResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $item = ConsumableItem::find($this->item_id);

        $array = [
            'id' => $this->id,
            'qty' => (float)$this->qty,
            'qty_type' => $this->qty_type,
            'expected_pcs' => (float)$this->expected_pcs,
            'category' => $item->category()->first()->name,
            'item' => $item->name
        ];
        
        return $array;
    }
}