<?php 

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class LimitlistPaginationResourceCollection extends ResourceCollection
{
    private $pagination;

    private $clazzName;

    public function __construct($data, $clazzName)
    {
        $this->pagination = [
            'total' => 1,
            'count' => 1,
            'per_page' => $data->count(),
            'current_page' => 1,
            'total_pages' => 1,
        ];
        
        $this->clazzName = $clazzName;

        parent::__construct($data);
    }

    public function toArray($request)
    {
       // dd($this->collection['data']);
       if(empty($this->clazzName)){
        return [
            'data' => $this->collection,
            'pagination' => $this->pagination
        ];   
       }
       
        return [
            'data' => $this->clazzName::collection($this->collection),
            'pagination' => $this->pagination
        ];
    }
    
}