<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBondProcessConsumableDetail extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_process_consumable', function (Blueprint $table) {
            $table->unsignedBigInteger('bond_process_id');
            $table->unsignedBigInteger('consumable_settings_id');
            $table->primary(['bond_process_id','consumable_settings_id'],'bond_consumable_id');
            $table->foreign('bond_process_id','bond_process_params_foreign')->references('id')->on('bond_process_params')->onDelete('cascade');;
            $table->foreign('consumable_settings_id', 'consumable_settings_foreign')->references('id')->on('consumable_settings')->onDelete('cascade');;
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bond_process_consumable');
    }
}
