<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBondRecipeProductionStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_recipe_production_status', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('material_id');
            $table->unsignedBigInteger('status_id');
           // $priority = CreateUsersTable::f(config('app_data.production_status_enum'));

           // $table->enum('status', $priority);
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->foreign('material_id')->references('material_id')->on('bond_material_recipes')->onDelete('cascade');;  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bond_recipe_production_status');
    }
}
